/*
 * Decompiled with CFR 0.152.
 */
package Utah.DAS.Serial;

import Utah.DAS.Serial.SerialIO;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SerialDAS
extends Thread {
    public static final int MAXINSTRUMENTS = 4;
    private SerialIO[] instrument;
    private boolean run;
    private Vector[] data;
    private boolean[] flushFlag;
    private boolean[] writeFlag;
    private String[] writeData;
    private int[] instrumentNums;
    private int runDelay;
    private String[] shutdownString;
    private int nPorts;

    public boolean openPort(int n, String string, int n2, int n3, int n4, int n5, char[] cArray, int n6, String string2, boolean bl) {
        if (n < 0 || n > 3) {
            if (bl) {
                System.err.println("openPort: Instrument number out of range.");
            }
            return false;
        }
        this.instrument[n] = new SerialIO(string, n2, n3, n4, n5, cArray);
        if (this.instrument[n].isOpen()) {
            if (this.instrument[n].setFlowControl(n6)) {
                if (this.instrument[n].write(string2)) {
                    this.instrumentNums[this.nPorts] = n;
                    ++this.nPorts;
                    this.shutdownString[n] = "";
                    return true;
                }
                if (bl) {
                    System.err.println("openPort: Error writing startup string.");
                }
            } else if (bl) {
                System.err.println("openPort: Error setting flow control.");
            }
        } else if (bl) {
            System.err.println("openPort: Error opening port.");
        }
        return false;
    }

    public void setRecordLength(int n, int n2) {
        if (n < 0 || n > 4) {
            return;
        }
        this.instrument[n].setRecordLength(n2);
    }

    public void setRecordChars(int n, char[] cArray) {
        if (n < 0 || n > 4) {
            return;
        }
        this.instrument[n].setRecordChars(cArray);
    }

    public void setShutdownString(int n, String string) {
        if (n < 0 || n > 4) {
            return;
        }
        this.shutdownString[n] = string;
    }

    public synchronized void setRunDelay(int n) {
        if (n < 0) {
            n = 25;
        }
        this.runDelay = n;
    }

    public void run() {
        int n;
        int n2;
        this.setPriority(8);
        while (this.run) {
            n2 = 0;
            while (n2 < this.nPorts) {
                String string;
                n = this.instrumentNums[n2];
                if (this.flushFlag[n]) {
                    this.instrument[n].flushInput();
                    this.flushFlag[n] = false;
                }
                if (this.writeFlag[n]) {
                    this.instrument[n].write(this.writeData[n]);
                    this.writeFlag[n] = false;
                }
                if ((string = this.instrument[n].readPort()) != null) {
                    this.data[n].add(string);
                }
                ++n2;
            }
            try {
                Thread.sleep(this.runDelay);
            }
            catch (InterruptedException interruptedException) {}
        }
        n2 = 0;
        while (n2 < this.nPorts) {
            n = this.instrumentNums[n2];
            this.instrument[n].write(this.shutdownString[n]);
            this.instrument[n].close();
            ++n2;
        }
    }

    public synchronized void end() {
        this.run = false;
    }

    public synchronized String read(int n) {
        if (n < 0 || n >= 4) {
            return null;
        }
        if (this.data[n].size() > 0) {
            return (String)this.data[n].remove(0);
        }
        return null;
    }

    public synchronized boolean write(int n, String string) {
        if (n < 0 || n >= 4) {
            return false;
        }
        if (this.writeFlag[n]) {
            return false;
        }
        this.writeFlag[n] = true;
        this.writeData[n] = string;
        return true;
    }

    public synchronized void flushInput(int n) {
        if (n < 0 || n >= 4) {
            return;
        }
        this.flushFlag[n] = true;
    }

    public synchronized void setInputBufferSize(int n, int n2) {
        if (n < 0 || n >= 4) {
            return;
        }
        this.instrument[n].setBufferSize(n2);
    }

    private final /* synthetic */ void this() {
        this.runDelay = 25;
    }

    public SerialDAS() {
        this.this();
        this.run = true;
        this.data = new Vector[4];
        this.instrumentNums = new int[4];
        this.instrument = new SerialIO[4];
        this.shutdownString = new String[4];
        this.writeData = new String[4];
        this.writeFlag = new boolean[4];
        this.flushFlag = new boolean[4];
        this.nPorts = 0;
        int n = 0;
        while (n < 4) {
            this.writeFlag[n] = false;
            this.flushFlag[n] = false;
            this.data[n] = new Vector(10);
            ++n;
        }
    }
}

