/*
 * Decompiled with CFR 0.152.
 */
package Utah.DAS.Serial;

import Utah.DAS.Serial.PortParams;
import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class SerialIO {
    private static Enumeration portList;
    private static CommPortIdentifier portId;
    private SerialPort portHandle;
    private int BUFFERSIZE;
    private int recordLength;
    private InputStream inputStream;
    private byte[] inputBuffer;
    private int bufOffset;
    private OutputStream outputStream;
    private char endRecordChar;
    private char startRecordChar;
    private boolean portOpen;

    public static String[] getPortNames() {
        int n = 0;
        portList = CommPortIdentifier.getPortIdentifiers();
        while (portList.hasMoreElements()) {
            portId = (CommPortIdentifier)portList.nextElement();
            if (portId.getPortType() != 1) continue;
            ++n;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        portList = CommPortIdentifier.getPortIdentifiers();
        while (portList.hasMoreElements()) {
            portId = (CommPortIdentifier)portList.nextElement();
            if (portId.getPortType() != 1) continue;
            stringArray[n2] = portId.getName();
            ++n2;
        }
        return stringArray;
    }

    public boolean isOpen() {
        return this.portOpen;
    }

    public boolean setParms(int n, int n2, int n3, int n4) {
        if (!this.portOpen) {
            return false;
        }
        switch (n2) {
            case 5: {
                n2 = 5;
                break;
            }
            case 6: {
                n2 = 6;
                break;
            }
            case 7: {
                n2 = 7;
                break;
            }
            case 8: {
                n2 = 8;
                break;
            }
            default: {
                n2 = 8;
            }
        }
        switch (n3) {
            case 1: {
                n3 = 1;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
            default: {
                n3 = 1;
            }
        }
        switch (n4) {
            case 0: {
                n4 = 0;
                break;
            }
            case 1: {
                n4 = 2;
                break;
            }
            case 2: {
                n4 = 1;
                break;
            }
            case 3: {
                n4 = 3;
                break;
            }
            case 4: {
                n4 = 4;
                break;
            }
            default: {
                n4 = 0;
            }
        }
        try {
            this.portHandle.setSerialPortParams(n, n2, n3, n4);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            return false;
        }
        return true;
    }

    public PortParams getParms() {
        if (!this.portOpen) {
            return new PortParams(0, 0, 0, 0);
        }
        int n = this.portHandle.getBaudRate();
        int n2 = this.portHandle.getParity();
        int n3 = this.portHandle.getStopBits();
        int n4 = this.portHandle.getDataBits();
        switch (n2) {
            case 0: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 4;
                break;
            }
            default: {
                n2 = -1;
            }
        }
        switch (n3) {
            case 1: {
                n3 = 1;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
            case 3: {
                n3 = 3;
                break;
            }
            default: {
                n3 = 0;
            }
        }
        switch (n4) {
            case 5: {
                n4 = 5;
                break;
            }
            case 6: {
                n4 = 6;
                break;
            }
            case 7: {
                n4 = 7;
                break;
            }
            case 8: {
                n4 = 8;
                break;
            }
            default: {
                n4 = 0;
            }
        }
        return new PortParams(n, n4, n3, n2);
    }

    public boolean setFlowControl(int n) {
        if (!this.portOpen) {
            return false;
        }
        switch (n) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 12;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            default: {
                n = 0;
            }
        }
        try {
            this.portHandle.setFlowControlMode(n);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            return false;
        }
        return true;
    }

    public void setBufferSize(int n) {
        this.BUFFERSIZE = n;
        this.inputBuffer = new byte[this.BUFFERSIZE];
        this.bufOffset = 0;
    }

    public void setRecordLength(int n) {
        if (n > this.BUFFERSIZE) {
            this.setBufferSize(n * 2);
        }
        this.recordLength = n;
    }

    public void setRecordChars(char[] cArray) {
        this.startRecordChar = cArray[0];
        this.endRecordChar = cArray[1];
    }

    public String readPort() {
        if (!this.portOpen) {
            return null;
        }
        int n = 0;
        try {
            while (this.inputStream.available() > 0) {
                int n2 = this.inputStream.read(this.inputBuffer, this.bufOffset, this.inputBuffer.length - this.bufOffset);
                this.bufOffset += n2;
                n += n2;
                if (this.bufOffset <= this.BUFFERSIZE - 1) continue;
                this.bufOffset = this.BUFFERSIZE - 1;
                break;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        if (n == -1) {
            return null;
        }
        String string = null;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        while (n5 < this.bufOffset) {
            if (this.inputBuffer[n5] == this.startRecordChar) {
                n4 = n5;
            }
            if (this.inputBuffer[n5] == this.endRecordChar) {
                n3 = n5;
                break;
            }
            ++n5;
        }
        if (this.startRecordChar == '\u0000') {
            n4 = 0;
        }
        if (this.endRecordChar == '\u0000' && this.bufOffset >= this.recordLength) {
            n3 = this.recordLength;
        }
        if (n4 > n3) {
            n4 = -1;
        }
        if (n4 != -1 && n3 != -1) {
            byte[] byArray = new byte[n3 - n4 + 1];
            n5 = n4;
            while (n5 <= n3) {
                byArray[n5 - n4] = this.inputBuffer[n5];
                ++n5;
            }
            string = new String(byArray);
            n5 = n3 + 1;
            while (n5 < this.bufOffset) {
                this.inputBuffer[n4 + (n5 - n3 - 1)] = this.inputBuffer[n5];
                ++n5;
            }
            n5 = n4 + (this.bufOffset - n3) - 1;
            while (n5 <= this.bufOffset) {
                if (n5 < 0) {
                    n5 = 0;
                }
                this.inputBuffer[n5] = 0;
                ++n5;
            }
            this.bufOffset = n4 + (this.bufOffset - n3) - 1;
            if (this.bufOffset < 0) {
                this.bufOffset = 0;
            }
        }
        return string;
    }

    public void flushInput() {
        if (!this.portOpen) {
            return;
        }
        try {
            int n = this.inputStream.available();
            this.inputStream.skip(n);
        }
        catch (IOException iOException) {}
        this.inputBuffer = new byte[this.BUFFERSIZE];
        this.bufOffset = 0;
    }

    public boolean write(String string) {
        if (!this.portOpen) {
            return false;
        }
        try {
            this.outputStream.write(string.getBytes());
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public void close() {
        this.portHandle.close();
        this.portOpen = false;
    }

    private final /* synthetic */ void this() {
        this.BUFFERSIZE = 64;
        this.bufOffset = 0;
        this.portOpen = false;
    }

    public SerialIO(String string, int n, int n2, int n3, int n4, char[] cArray) {
        this.this();
        this.inputBuffer = new byte[this.BUFFERSIZE];
        this.bufOffset = 0;
        portList = CommPortIdentifier.getPortIdentifiers();
        this.portOpen = false;
        while (portList.hasMoreElements()) {
            portId = (CommPortIdentifier)portList.nextElement();
            if (portId.getPortType() != 1 || !portId.getName().equals(string)) continue;
            this.portOpen = true;
            try {
                this.portHandle = (SerialPort)portId.open("SerialDAS", 2000);
            }
            catch (PortInUseException portInUseException) {
                this.portOpen = false;
            }
            try {
                this.inputStream = this.portHandle.getInputStream();
            }
            catch (IOException iOException) {
                this.portOpen = false;
            }
            try {
                this.outputStream = this.portHandle.getOutputStream();
            }
            catch (IOException iOException) {
                this.portOpen = false;
            }
            if (!this.setParms(n, n2, n3, n4)) {
                this.portOpen = false;
            }
            this.portHandle.setInputBufferSize(this.BUFFERSIZE);
            try {
                this.portHandle.enableReceiveTimeout(50);
            }
            catch (UnsupportedCommOperationException unsupportedCommOperationException) {
                this.portOpen = false;
            }
            break;
        }
        this.startRecordChar = cArray[0];
        this.endRecordChar = cArray[1];
    }
}

